#region References

using System;
using System.Collections;
using System.Configuration;
using System.IO;
using System.Reflection;
using System.Threading;
using System.Windows.Forms;
using Spring.Context.Support;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.Common.DependencyInjection;
using gov.va.med.vbecs.Common.Log;
using gov.va.med.vbecs.DAL.VAL;
using gov.va.med.vbecs.DAL.VistALink.Client;
using gov.va.med.vbecs.GUI;
using gov.va.med.vbecs.GUI.controls;
using gov.va.med.vbecs.admin.GUI.Lock;
using gov.va.med.vbecs.admin.GUI.LockB;
using gov.va.med.vbecs.Lock;
using Action = System.Action;

#endregion

namespace gov.va.med.vbecs.admin.GUI
{
	/// <summary>
	/// Main application window.
	/// </summary>
	public class FrmVBECSAdmin : FrmAppMainFormBase
	{
        //log4net
        private static ILogger _logger;

		// Used for Caching VistA data
		private Thread _vistaCachingThread;

		private Thread _appInitThread;
		private bool _appInitFinished;
		private Exception _appInitException;
		private bool _appShutdownRequestedDuringInit;

		private System.Windows.Forms.MainMenu mnuMain;
		private System.Windows.Forms.MenuItem mnuFile;
		private System.Windows.Forms.MenuItem mnuHelp;
		private System.Windows.Forms.MenuItem mnuDivisions;
		private System.Windows.Forms.MenuItem mnuUsers;
		private System.Windows.Forms.MenuItem mnuSplit;
		private System.Windows.Forms.MenuItem mnuExit;
		private System.Windows.Forms.MenuItem mnuAbout;
		private System.Windows.Forms.MenuItem mnuInterfaces;
		private System.Windows.Forms.StatusBarPanel sbpLoginID;
		private System.Windows.Forms.GroupBox grpHeader;
		private System.Windows.Forms.StatusBarPanel sbpVistALink;
		private System.Windows.Forms.ImageList imageListMain;
		private System.ComponentModel.IContainer components;

		/// <summary>
		/// StatusBar object
		/// </summary>
		protected System.Windows.Forms.StatusBar mainStatusbar;

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmVBECSAdmin() : base()
		{
			// Required for Windows Form Designer support
			InitializeComponent();

			this.vbecsLogo1.Title = this.Text;
			this.vbecsLogo1.Visible = false;
			this.RequiredFieldsLabel = false;			
			
			_appInitThread = null;
			_appInitFinished = false;
			_appInitException = null;
			_appShutdownRequestedDuringInit = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmVBECSAdmin));
			this.mnuMain = new System.Windows.Forms.MainMenu();
			this.mnuFile = new System.Windows.Forms.MenuItem();
			this.mnuInterfaces = new System.Windows.Forms.MenuItem();
			this.mnuDivisions = new System.Windows.Forms.MenuItem();
			this.mnuUsers = new System.Windows.Forms.MenuItem();
			this.mnuSplit = new System.Windows.Forms.MenuItem();
			this.mnuExit = new System.Windows.Forms.MenuItem();
			this.mnuHelp = new System.Windows.Forms.MenuItem();
			this.mnuAbout = new System.Windows.Forms.MenuItem();
			this.imageListMain = new System.Windows.Forms.ImageList(this.components);
			this.mainStatusbar = new System.Windows.Forms.StatusBar();
			this.sbpLoginID = new System.Windows.Forms.StatusBarPanel();
			this.sbpVistALink = new System.Windows.Forms.StatusBarPanel();
			this.grpHeader = new System.Windows.Forms.GroupBox();
			((System.ComponentModel.ISupportInitialize)(this.sbpLoginID)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.sbpVistALink)).BeginInit();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Location = new System.Drawing.Point(0, 3);
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(612, 30);
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 554);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.Visible = false;
			// 
			// mnuMain
			// 
			this.mnuMain.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.mnuFile,
																					this.mnuHelp});
			// 
			// mnuFile
			// 
			this.mnuFile.Index = 0;
			this.mnuFile.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.mnuInterfaces,
																					this.mnuDivisions,
																					this.mnuUsers,
																					this.mnuSplit,
																					this.mnuExit});
			this.mnuFile.Text = "&File";
			// 
			// mnuInterfaces
			// 
			this.mnuInterfaces.Index = 0;
			this.mnuInterfaces.Text = "Configure &Interfaces";
			this.mnuInterfaces.Click += new System.EventHandler(this.mnuInterfaces_Click);
			// 
			// mnuDivisions
			// 
			this.mnuDivisions.Index = 1;
			this.mnuDivisions.Text = "Configure &Divisions";
			this.mnuDivisions.Click += new System.EventHandler(this.mnuDivisions_Click);
			// 
			// mnuUsers
			// 
			this.mnuUsers.Index = 2;
			this.mnuUsers.Text = "Configure &Users";
			this.mnuUsers.Click += new System.EventHandler(this.mnuUsers_Click);
			// 
			// mnuSplit
			// 
			this.mnuSplit.Index = 3;
			this.mnuSplit.Text = "-";
			// 
			// mnuExit
			// 
			this.mnuExit.Index = 4;
			this.mnuExit.Text = "E&xit";
			this.mnuExit.Click += new System.EventHandler(this.mnuExit_Click);
			// 
			// mnuHelp
			// 
			this.mnuHelp.Index = 1;
			this.mnuHelp.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					this.mnuAbout});
			this.mnuHelp.Text = "&Help";
			// 
			// mnuAbout
			// 
			this.mnuAbout.Index = 0;
			this.mnuAbout.Text = "&About";
			this.mnuAbout.Click += new System.EventHandler(this.mnuAbout_Click);
			// 
			// imageListMain
			// 
			this.imageListMain.ImageSize = new System.Drawing.Size(16, 16);
			this.imageListMain.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListMain.ImageStream")));
			this.imageListMain.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// mainStatusbar
			// 
			this.mainStatusbar.Location = new System.Drawing.Point(0, 570);
			this.mainStatusbar.Name = "mainStatusbar";
			this.mainStatusbar.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
																							 this.sbpLoginID,
																							 this.sbpVistALink});
			this.mainStatusbar.ShowPanels = true;
			this.mainStatusbar.Size = new System.Drawing.Size(612, 23);
			this.mainStatusbar.TabIndex = 8;
			// 
			// sbpLoginID
			// 
			this.sbpLoginID.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
			this.sbpLoginID.Text = "Login ID: ";
			this.sbpLoginID.Width = 514;
			// 
			// sbpVistALink
			// 
			this.sbpVistALink.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
			this.sbpVistALink.Icon = ((System.Drawing.Icon)(resources.GetObject("sbpVistALink.Icon")));
			this.sbpVistALink.Text = "VistALink";
			this.sbpVistALink.Width = 82;
			// 
			// grpHeader
			// 
			this.grpHeader.Dock = System.Windows.Forms.DockStyle.Top;
			this.grpHeader.Location = new System.Drawing.Point(0, 0);
			this.grpHeader.Name = "grpHeader";
			this.grpHeader.Size = new System.Drawing.Size(612, 3);
			this.grpHeader.TabIndex = 11;
			this.grpHeader.TabStop = false;
			// 
			// FrmVBECSAdmin
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(612, 593);
			this.Controls.Add(this.mainStatusbar);
			this.Controls.Add(this.grpHeader);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.IsMdiContainer = true;
			this.Menu = this.mnuMain;
			this.MinimumSize = new System.Drawing.Size(620, 620);
			this.Name = "FrmVBECSAdmin";
			this.RequiredFieldsLabel = true;
			this.ShowInTaskbar = true;
			this.Text = "VBECS Administrator";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.FrmVBECSAdmin_Closing);
			this.Load += new System.EventHandler(this.FrmVBECSAdmin_Load);
			this.Controls.SetChildIndex(this.grpHeader, 0);
			this.Controls.SetChildIndex(this.mainStatusbar, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			((System.ComponentModel.ISupportInitialize)(this.sbpLoginID)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.sbpVistALink)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
#if DESIGN
			GuiMessenger.ShowMessageBox( Common.StrRes.SysErrMsg.Common.AttemptToRunInDesignConfiguration() );
			Application.Exit();
			return;
#endif
			try
			{
                initialize_dependencies();

				InitializeGlobalExceptionHandling();

                //CR 3454
                string dbVersion = string.Concat(BOL.VbecsVersion.CurrentVersion);
                string exeVersion = Assembly.GetExecutingAssembly().GetName().Version.ToString();
                bool isVBECSRunningInIDE = System.Diagnostics.Debugger.IsAttached;

                if (!isVBECSRunningInIDE)
                {
                    if (!string.Equals(dbVersion, exeVersion))
                    {
                        GuiMessenger.ShowMessageBox(StrRes.SysErrMsg.Common.MisMatchedBuild(exeVersion, dbVersion));
                        ExitApplication(false, true);
                        return;
                    }
                }
				using( new VbecsAdminAppStartupLock() )
				{
					if( !LogonUserToVbecsAdministrator() )
					{
						ExitApplication( false, true );
						return;
					}

					Application.DoEvents();

					AppMainForm = new FrmVBECSAdmin();
                    _logger.Debug("Start VBECS Admin application");
					Application.Run( AppMainForm );
				}
			}
            catch (AppLockingException ex)
            {
                // MBR_1.09
                GuiMessenger.ShowMessageBox(ex.Item);
                ExitApplication(true, true);
            }
			finally 
			{
				AppMainForm = null;
				ExitApplication( true, true ); // Exiting program - without this user could be trapped in an infinite loop
			}
		}

        static private void initialize_dependencies()
        {
            //Globally setup log output file name
            log4net.GlobalContext.Properties["LogName"] = Path.GetFileNameWithoutExtension(Assembly.GetEntryAssembly().Location);
            log4net.GlobalContext.Properties["LogNameDated"] = Path.GetFileNameWithoutExtension(Assembly.GetEntryAssembly().Location) + DateTime.Now.ToString("_MM-dd-yyyy");

            var log4NetFile = Path.Combine(Path.GetDirectoryName(typeof(FrmVBECSAdmin).Assembly.Location) ?? ".", ConfigurationManager.AppSettings.Get("log4net.Config"));
            log4net.Config.XmlConfigurator.ConfigureAndWatch(new FileInfo(log4NetFile));

            //Two configuration files are necessary since object in first file should be created and ready for object in the second one.
            var common = @"file://" + Path.Combine(Path.GetDirectoryName(typeof(FrmVBECSAdmin).Assembly.Location) ?? ".", ConfigurationManager.AppSettings.Get("SpringConfigFileCommon"));
            var spring = @"file://" + Path.Combine(Path.GetDirectoryName(typeof(FrmVBECSAdmin).Assembly.Location) ?? ".", ConfigurationManager.AppSettings.Get("SpringConfigFile"));
            DiContext.AppContext = new XmlApplicationContext(new[] { common, spring });

            //Here is the once-per-class call to initialize the log object
            //We have to do it after Spring.NET objects initialization.
            _logger = LogManager.Instance().LoggerLocator.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);
        }

		private static bool LogonUserToVbecsAdministrator()
		{
			try
			{
				using( new WaitCursor() )
					VbecsUser.LogonToVbecsAdministrator();

				return true;
			}
			catch( VbecsLogonException xcp )
			{
				GuiMessenger.ShowMessageBox( Common.StrRes.SysErrMsg.MUC01.VbecsAdministratorLogonError( Environment.NewLine + Environment.NewLine, xcp.Message ) );
				return false;
			}
		}

		private void mnuInterfaces_Click(object sender, System.EventArgs e)
		{
			StartSingleUserModeDialogFromMenuClickAndUpdateMenuAfter( new DlgEditCombinedInterfaces() );
		}

		/// <summary>
		/// Divisions Click Event Handler
		/// </summary>
		private void mnuDivisions_Click(object sender, System.EventArgs e)
		{
			if( !DAL.VAL.VistALink.EnsureAvailability() )
				return;

			try
			{
				DlgEditDivisionParameters dlg = new DlgEditDivisionParameters();
				this.RegisterDialog( dlg );
				StartSingleUserModeDialogFromMenuClickAndUpdateMenuAfter( dlg );
			}
			finally
			{
				this.RegisterDialog( null );
			}
		}

		private void mnuUsers_Click(object sender, System.EventArgs e)
		{
			if( !DAL.VAL.VistALink.EnsureAvailability() )
				return;

			try
			{
				DlgEditUserParameters dlg = new DlgEditUserParameters();
				this.RegisterDialog( dlg );
				dlg.ShowDialog(this);
			}
			finally
			{
				this.RegisterDialog( null );
			}
		}

		private void StartSingleUserModeDialogFromMenuClickAndUpdateMenuAfter( DlgAdminBase dialogToStart )
		{
            try
            {
                using (new VbecsAdminSingleUserModeLock())
                {
                    StartDialogFromMenuClickAndUpdateMenuAfter(dialogToStart);
                }
            }
            catch (AppLockingException ex)
            {
                GuiMessenger.ShowMessageBox(ex.Item);
            }
		}

		private void StartDialogFromMenuClickAndUpdateMenuAfter( DlgAdminBase dialogToStart )
		{
			StartDialogFromMenuClick( dialogToStart );

			this.Refresh();
			UpdateMenuItems();
		}

		private void StartDialogFromMenuClick( DlgAdminBase dialogToStart )
		{
			if( dialogToStart == null )
				throw( new ArgumentNullException( "dialogToStart" ) );

			this.Refresh();
			dialogToStart.ShowDialog( this );
		}

		private void mnuExit_Click(object sender, System.EventArgs e)
		{
			this.Refresh();
			this.Close();
		}

		private void mnuAbout_Click(object sender, System.EventArgs e)
		{
			//CR2465 - Code-reuse, using the main VBECS Help window, also Font Sizes were increased to improve legability
			new med.vbecs.GUI.FrmAboutBox("VistA Blood Establishment Computer Software (VBECS) Administrator").ShowDialog(this);
		}

		private void FrmVBECSAdmin_Load(object sender, System.EventArgs e)
		{			
			this.Refresh();
			PerformApplicationInitialization();
		}

		private void SetMenuState( bool state )
		{
			lock(this)
				foreach( MenuItem _mnuItem in mnuMain.MenuItems )
					_mnuItem.Enabled = state;
		}

		private void PerformApplicationInitialization()
		{
			SetMenuState( false );
			EnableWaitCursor();			
			
			StartAppInitialization();
			
			while( true )
			{				
				Application.DoEvents();
				Thread.Sleep( 100 );

				if( _appInitFinished )
					break;
			}

			if( _appShutdownRequestedDuringInit )
				return;

			if( _appInitException != null )
				throw _appInitException;

			SetMenuState( true );			
			DisableWaitCursor();
			UpdateMenuItems();

            PerformLockingCleanup();        //CR3311
		}

		private void StartAppInitialization()
		{
			lock( this )
			{
				_appInitThread = new Thread( new ThreadStart( AppInitThread ) );
				_appInitThread.Start();
			}
		}

		private void AppInitThread()
		{
			try
			{				
				InitAndConnectVistALink();
                UpdateUserNameStatusBarPanel();
				UpdateVistALinkStatusBarPanel(VistALink.IsAvailable);								
			}
			catch( Exception xcp )
			{	
				_appInitException = xcp; // thread exception is saved there and rethrown in the main app thread.
			}
			finally
			{
				_appInitFinished = true;
				_appInitThread = null;
			}
		}

		private void InitAndConnectVistALink()
		{
			VistALink.Initialize( new VistALinkUIBinder( this ), null );			
			VistALink.ConnectionStateChanged += VistALinkConnectionStateChangedHandler;

			var currentConfig = VistALinkConfig.GetCurrent();

            // CR3414: IsNew is always false since data is loaded from DB all the time. In future, this check can be removed (approved by Lohse).
			if( currentConfig.IsNew )
				return;

		    try
		    {
                VistALink.SetPrimaryServer(currentConfig.GetServerConnectionInfo());
		    }
		    catch (Exception ex)
		    {
		        //some problem preparing vista link connection (CR3414)
                _logger.Error("Some problem preparing vista link connection", ex);
                //Don't re-throw since we don't want to crash application if there is not VistALink connection.
		        return;
		    }
		    try
		    {
		        VistALink.Connect();
		    }
            catch (Exception ex)
            {
                //some problem connecting to vista link (CR3414)
                _logger.Error("Some problem connecting to vista link", ex);
                //Don't re-throw since we don't want to crash application if there is not VistALink connection.
                return;
            }
            //
			// Cache VistA data; use a new Thread so user does not have to wait
			_vistaCachingThread = new Thread(HandleVistaCaching);
			_vistaCachingThread.Start();
		}

		private void VistALinkConnectionStateChangedHandler( object sender, VistALinkConnectionStateChangedEventArgs e )
		{
			lock( this )
                UpdateVistALinkStatusBarPanel(VistALink.IsAvailable);
		}

        //CR3414 & CR3413
		private void UpdateVistALinkStatusBarPanel(bool isAvailable)
		{
            if (sbpVistALink.Parent.InvokeRequired)
            {
                sbpVistALink.Parent.BeginInvoke(new Action(() =>
                {
                    sbpVistALink.Icon =
                        (isAvailable ? VbecsIcon.VistALinkConnected : VbecsIcon.VistALinkDown).Icon;
                }));
            }
            else
            {
                sbpVistALink.Icon =
                        (isAvailable ? VbecsIcon.VistALinkConnected : VbecsIcon.VistALinkDown).Icon;
            }
		}

		private void UpdateUserNameStatusBarPanel()
		{
            this.Invoke(new MethodInvoker(delegate { sbpLoginID.Text = String.Concat( "Login ID: ", Environment.UserName.ToUpper());}));
        }
		private void FrmVBECSAdmin_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			EnableWaitCursor();
		}

		/// <summary>
		/// StopAllWorkerThreads
		/// </summary>
		protected override void StopAllWorkerThreads()
		{
			lock( this )
			{
				if( _appInitThread != null )
				{
					_appShutdownRequestedDuringInit = true;
					_appInitThread.Abort();
					_appInitThread.Join( 1000 );
					_appInitThread = null;
				}

				if( _vistaCachingThread != null )
					_vistaCachingThread.Abort();
			}
		}

		/// <summary>
		/// This is used to enable wait cursor for the main form as opposed to enabling it for everything using WaitCursor().
		/// </summary>
		private void EnableWaitCursor()
		{
			lock( this )
				this.Cursor = Cursors.WaitCursor;
		}

		/// <summary>
		/// Disables main form's wait cursor.
		/// </summary>
		private void DisableWaitCursor()
		{
			lock( this )
				this.Cursor = Cursors.Default;
		}

		private void UpdateMenuItems()
		{
			using( new WaitCursor() )
			{
				mnuInterfaces.Enabled = true;
				mnuDivisions.Enabled = IsVistALinkIsConfigured && AreAllHl7InterfacesConfigured;
				mnuUsers.Enabled = mnuDivisions.Enabled && AtLeastOneDivisionIsConfigured;
			}
		}

		private bool IsVistALinkIsConfigured
		{
			get
			{
				return !VistALinkConfig.GetCurrent().IsNew;
			}
		}

		private bool AreAllHl7InterfacesConfigured
		{
			get
			{
				//CR 2948 Added check for InterfaceActiveIndicator
				foreach( HL7InterfaceConfig _config in HL7InterfaceConfig.GetHL7InterfaceConfigs() )
					if( !_config.IsValid && _config.Interface.InterfaceActiveIndicator == true)
						return false;

				return true;
			}
		}

		private bool AtLeastOneDivisionIsConfigured
		{
			get
			{
				return DivisionDefinition.GetAllDivisionsDefListFromVbecs().Count > 0;				
			}
		}

		#region VistACache

		private void HandleVistaCaching()
		{
			// Cache VistA data
			if(_vistaCachingThread.IsAlive)
			{
				VistaCache.UpdateCache(VbecsConfig.Current.VistACacheRefreshInterval);
			}
		}

		#endregion
	}
}
